#rR genoret/genoret_show.tcl
proc RotateText {} {

    set K [UnCanva]
    
    package require BLT
    ::blt::bitmap compose myNewBitmap "this is a text" \
	    -font "Arial 10 bold" \
	    -rotate 60 \
	    -justify left
    $K create bitmap 50 50 -bitmap myNewBitmap \
	    -foreground blue \
	    -anchor nw \
	    
}


proc ExpandList {List N} {
    if {$List=={}} { return {} }
    set ExpandedList $List
    while {[llength $ExpandedList]<$N} {
	LConcat ExpandedList $List
    }
    return $ExpandedList
}

proc ScaleLists {ListOfScales List} {
    set NewList {} 
    set ExpandedListOfScale [ExpandList $ListOfScales [llength $List]]
    foreach S $ExpandedListOfScale E $List {
	lappend NewList [expr $S*$E]
    }
    return $NewList
}

proc AddLists {ListOfOffsets List} {
    set NewList {} 
    set ExpandedListOfOffsets [ExpandList $ListOfOffsets [llength $List]]
    foreach O $ExpandedListOfOffsets E $List {
	lappend NewList [expr $E+$O]
    }
    return $NewList
}

proc MulListByMat {Mat List} {
    set NewList {}
    set L [llength $List]
    set N [llength $Mat]
    set I 0
    while 1 {
	if {$I>=$L} { break }
	set V [lrange $List $I [expr $I+$N-1]]
	incr I $N
	set W [V_MV $Mat * $V ]
	LConcat NewList $W
    }
    return $NewList
}

proc Secteur {{AngleMin ""} {AngleMax ""} {RayonMin ""} {RayonMax ""} {Resolution ""} {Torsion ""}} {
    if {$Resolution==""} { set Resolution 99 }
    if {$RayonMin==""} { set RayonMin 0. }
    if {$RayonMax==""} { set RayonMax [Maxi 1. [expr 2*$RayonMin]] }
    if {$AngleMin==""} { set AngleMin 0.0 }
    if {$AngleMax==""} { set AngleMin [TwoPi] }
    if {$Torsion==""} { set Torsion [expr [Pi]/(4*$RayonMax)] }

    set AngleMin1 [expr $AngleMin + $Torsion*$RayonMin]
    set AngleMax1 [expr $AngleMax + $Torsion*$RayonMin]
    set AngleMin2 [expr $AngleMax + $Torsion*$RayonMin]
    set AngleMax2 [expr $AngleMax + $Torsion*$RayonMax]
    set AngleMin3 [expr $AngleMax + $Torsion*$RayonMax]
    set AngleMax3 [expr $AngleMin + $Torsion*$RayonMax]
    set AngleMin4 [expr $AngleMin + $Torsion*$RayonMax]
    set AngleMax4 [expr $AngleMin + $Torsion*$RayonMin]

    set Secteur {}
    LConcat Secteur [Spirale $AngleMin1 $AngleMax1 $RayonMin $RayonMin $Resolution]
    LConcat Secteur [Spirale $AngleMin2 $AngleMax2 $RayonMin $RayonMax $Resolution]
    LConcat Secteur [Spirale $AngleMin3 $AngleMax3 $RayonMax $RayonMax $Resolution]
    LConcat Secteur [Spirale $AngleMin4 $AngleMax4 $RayonMax $RayonMin $Resolution]

    return $Secteur
}

proc Spirale {{AngleMin ""} {AngleMax ""} {RayonMin ""} {RayonMax ""} {Resolution ""}} {
    if {$RayonMin==""} { set RayonMin 0. }
    if {$RayonMax==""} { set RayonMax [Maxi 1. [expr 2*$RayonMin]] }
    if {$AngleMin==""} { set AngleMin 0.0 }
    if {$AngleMax==""} { set AngleMin [TwoPi] }
    if {$Resolution==""} { set Resolution 33 }

    set i 0
    set iMax [Maxi 2 [expr abs($Resolution*($AngleMax-$AngleMin)/[TwoPi])]]
    set Spirale {}
    set DeltaA [expr ($AngleMax-$AngleMin)/$iMax]
    set DeltaR [expr ($RayonMax-$RayonMin)/$iMax]
    while {$i<=$iMax} {
	set Rayon [expr $RayonMin+$i*$DeltaR]
	set Alpha [expr $AngleMin+$i*$DeltaA]
	set X [expr $Rayon*cos($Alpha)]
	set Y [expr $Rayon*sin($Alpha)]
	lappend Spirale $X $Y
	incr i
    }
    return $Spirale
}

proc PiSur N {
    return [expr [Pi]/$N]
}

proc RayX {{N ""} {Value ""}}  {
    global RayX MaxR
    if {[string equal -nocase $N "isNotSet"]} { return  [expr ! [info exists RayX]] }
    if {[string equal -nocase $N "setRayXTo" ]} { set RayX $Value ; set N "" }
    if {[string equal -nocase $N "setMaxRTo" ]} { set RayX $Value ; set N "" }
    if { ! [info exists RayX]} { set RayX 400 ; set MaxR 10 }
    if {$N==""} { set N $MaxR }
    return [expr $N*$RayX./$MaxR]
}

proc Mire {{NbCercles ""} {NbSecteurs ""} {Torsion ""} {Taille ""} {FichierImage ""}} {
    global Mire

    set Chapters [list \
	    SOPs \
	    Gallery \
	    DataFiles \
	    HttpLinks \
	    Clinical \
	    Transcriptomics \
	    Genes \
	    Centers \
	    Components \
	    WPs \
	    People \
	    Misc]
    set Tasks [list \
	    Search \
	    Browse \
	    View \
	    Modify \
	    Deposit \
	    Do]


    if {$FichierImage=="" && [regexp -nocase {[a-z]} $NbCercles]} { set FichierImage $NbCercles ; set NbCercles "" }

    if { ! [info exists Mire(NbCercles)]}  { set Mire(NbCercles)  [llength $Tasks] }
    if { ! [info exists Mire(NbSecteurs)]} { set Mire(NbSecteurs) [llength $Chapters] }
    if { ! [info exists Mire(Torsion)]}    { set Mire(Torsion)    [expr [PiSur 8]/[RayX]] }


    if {$NbCercles ==""} { set NbCercles  $Mire(NbCercles) }
    if {$NbSecteurs==""} { set NbSecteurs $Mire(NbSecteurs) }
    if {$Torsion   ==""} { set Torsion    $Mire(Torsion) }
    if {$NbCercles =="Ask"} { set NbCercles  [Entre $Mire(NbCercles)] }
    if {$NbSecteurs=="Ask"} { set NbSecteurs [Entre $Mire(NbSecteurs)] }
    if {$Torsion   =="Ask"} { set Torsion    [Entre $Mire(Torsion)] }

    set Mire(NbCercles)  $NbCercles
    set Mire(NbSecteurs) $NbSecteurs
    set Mire(Torsion)    $Torsion

    if {$Taille    ==""} { set Taille 800 }
    if {[RayX "isNotSet"]} {
	Rayx "setRayXTo" [expr $Taille*0.45]
	Rayx "setMaxRTo" $NbCercles
    }
    set MaxX $Taille
    set MaxY $Taille
    set K [UnCanva $MaxX $MaxY $MaxX $MaxY]

    regsub ".canvas$" $K "" Fen
    set B [BoutonneLaFenetre $Fen "Chg cirles/sector/torsion"]
    bind $B  <1> "Mire Ask {} {}"
    bind $B  <2> "Mire {} Ask {}"
    bind $B  <3> "Mire {} {} Ask"

    set CentreX [expr $MaxX / 2]
    set CentreY [expr $MaxY / 2]
    set Centre [list $CentreX $CentreY]

    set LesCouleurs {}
    set MaxNC 31

    foreach C [NombresEntre 0 [expr $MaxNC-1]] {
	set Amour [expr (1.0*$C)/$MaxNC]
#	lappend LesCouleurs [Nuance $Amour 0.65 0.5]
	lappend LesCouleurs [Sature $Amour 0.1 1.0 0.75]
    }
    set LineColor "grey"
    set LineWidth 3

    set ICouleur 0
    set MaxNA [llength $Chapters]
    set MaxNR [llength $Tasks]
    set NR 0
    set Hue 0.5
    foreach Ta $Tasks {
	set Hue [expr $Hue+0.02]
	incr NR
	set R0 [RayX $NR]
	set R1 [RayX [expr $NR+1]]
	set NA 0
	set Sat 0.1
	foreach Ch $Chapters {
	    set Sat [expr $Sat + 0.05]
	    incr NA
	    set Couleur [Sature $Sat $Sat $Sat $Hue]
	    set A0 [expr (($NA-1)*[TwoPi])/$MaxNA]
	    set A1 [expr ($NA*[TwoPi])/$MaxNA]
	    set Trace [Secteur $A0 $A1 $R0 $R1 "" $Torsion]
	    set Trace [AddLists $Centre $Trace]
	    $K create polygon $Trace -outline $LineColor -width $LineWidth -fill $Couleur
	    set Ref "../Project/phrame.php?action=doGenoretMapArea&chapter=$Ch&task=$Ta"
	    lappend LesAreas [Area $Trace $Ref]
	}
    }
    set Areas [join $LesAreas "\n"]
    if {$FichierImage!=""} { CanvaEnPNG $K Visible $FichierImage }
    return $Areas
}

proc CreateMapArea {{Fichier ""}} {
    set Queue "GenoretTargetMap.png"
    set FichierImage "[GenoretArea]/$Queue"
    lappend LeHtml "<img src=\"http://www-genoret.u-strasbg.fr/genoret/area/$Queue\"] border=\"0\" usemap=\"#GenoretTargetMap\">"
    lappend LeHtml "<map name=\"GenoretTargetMap\">"
    lappend LeHtml [Mire $FichierImage]
    lappend LeHtml "</map>"
    return [SauveLesLignes $LeHtml dans $Fichier]
}

proc Area {Trace {Ref ""}} {
    if {$Ref==""} { set Ref "NoHref" }
    set LesCoords {}
    foreach X $Trace {
	set C [expr round($X)]
	lappend LesCoords $C
    }
    set Coords [join $LesCoords ","]
    set Texte "<area shape=\"poly\" coords=\"$Coords\" href=\"$Ref\">"
    return $Texte
}

proc ReloadListBox {L NewList} {
    $L delete 0 end
    foreach Line $NewList {
	$L insert end $Line
    }
}

proc EditAndShowQueries {Texte {FichierPourSave ""} {Maniere ""}} {
    return [Affiche [EntreTexte $Texte] "AvecFormateAvecSaveQueries$Maniere" $FichierPourSave]
}

proc LaManierePourAffiche TypeDeFichier {
    return ""
}

proc AfficheVariable {Page {Maniere ""} {NomDuFichierOrigine ""}} {
    FaireLire "AfficheVariable a corriger"
    return [Affiche $Page $Maniere $NomDuFichierOrigine]
}

proc Affiche {Page {Maniere ""} {NomDuFichierOrigine ""}} {
    Wup "Cette proc vient de AfficheVariable qui est le coeur de Gscope"
    Wup "Most used procedure (from Gscope) ... : "
    Wup "Shows the text Page in a listbox, with a lot of buttons."
    Wup "Copyright 1999 Raymond Ripp"
    
    if {$Page==""} { return "" }
    
    global VariableDeRetour
    global PagePropre
        
    set Nom ""
    set Queue [file tail $NomDuFichierOrigine]
    set PossibleQuery $NomDuFichierOrigine

    set w [NomDe fenetre]

    regsub -all {\t} $Page "        " PagePropre($w)

    lappend LesFenetresDePAB($Queue) $w
    
    if { $NomDuFichierOrigine == "" } {
	set NomDuFichierOrigine "Tsointsoin"
    }

    if {$Maniere=="AutoManiere" || $Maniere==""} {
	set Maniere [LaManierePourAffiche $NomDuFichierOrigine]
    }

    toplevel $w
    set Titre "$NomDuFichierOrigine"

    wm title $w "$Titre"
    wm iconname $w "$Titre"

    label $w.msg -wraplength 4i -justify left -text "$Titre"
    pack  $w.msg -side top

    set Clavier $w.buttons
    frame  $Clavier
    pack   $Clavier -side bottom -fill x -padx 3m -pady 1m

    TouchePour $Clavier NouvelleGamme
    TouchePour $Clavier NouvelleCouleur "red"
    if { [regexp "AvecRetour" $Maniere] } {
	TouchePour $Clavier "Validate sel." "set VariableDeRetour($w) \[selection get\]"      "" "green"
	TouchePour <2>      " /All"         "set VariableDeRetour($w) \[set PagePropre($w)\]" ""
	TouchePour <3>      " / No!"        "set VariableDeRetour($w) {}"
	TouchePour $Clavier NouvelleCouleur "pink"
    }
    TouchePour $Clavier "Dismiss"     "unset PagePropre($w) ; after 10 destroy $w"
    TouchePour $Clavier "Dismiss_all" "DismissToutCePAB $Queue"

    TouchePour $Clavier NouvelleCouleur "grey"
    TouchePour $Clavier "Save all"   "SaveAs      \[set PagePropre($w)\]"
    TouchePour <2>      "/sel."      "SaveAs      \[selection get\]"
    TouchePour <3>      " /Edit"     "EditAndShow \[set PagePropre($w)\]"
    TouchePour $Clavier "Memorize sel." "MemoSelection $w Memorize" "" lightyellow
    TouchePour <2>      "/Recall"       "MemoSelection $w Recall"
    TouchePour $Clavier NouvelleCouleur "grey"
    TouchePour $Clavier "Print"         "ImprimeLeTexte \[set PagePropre($w)\]"
    TouchePour <2>      "/Sort"         "TrieEtAffiche \[set PagePropre($w)\] Alpha $Maniere $NomDuFichierOrigine"
    TouchePour <3>      "/ask"          "TrieEtAffiche \[set PagePropre($w)\] Ask $Maniere $NomDuFichierOrigine"
    TouchePour $Clavier "Copy"          "clipboard clear ; clipboard append \[selection get\]"
    TouchePour <2>      "/Append"       "clipboard append \[selection get\]"
    TouchePour <3>      " /Font"        "PolicePourListBox Ask $w"
    TouchePour $Clavier "Exec"          "ExecuteUnBoutonDe $w"
    TouchePour <2>      "/Small"        "RapetisseLesBoutonsDe $w"
    TouchePour <3>      "/Kill"         "DetruitUnBoutonDe $w"

    TouchePour $Clavier NouvelleGamme
    TouchePour $Clavier NouvelleCouleur "yellow"
    TouchePour $Clavier "Next" "Focalise $w"
    TouchePour <2>      "/Top"  "Focalise $w top" 
    TouchePour <3>      "/New"  "Focalise $w ask"
    TouchePour $Clavier "High word"           "Illumine \[Entre\] $w"
    TouchePour <2>      "/?"                  "IllumineLeGroupeDe $Nom $w Ask $Maniere"
    TouchePour $Clavier "Sel. In"   "AfficheRognure \[set PagePropre($w)\] \[selection get\] $Maniere $NomDuFichierOrigine In"  
    TouchePour <2>      "/Out"      "AfficheRognure \[set PagePropre($w)\] \[selection get\] $Maniere $NomDuFichierOrigine Out"  
    TouchePour <3>      "/Alone"    "AfficheRognure \[set PagePropre($w)\] \[selection get\] $Maniere $NomDuFichierOrigine Alone"  
    
    set NomX "x"
    TouchePour $Clavier "NewButton" "NouveauBouton $w New  $NomX $NomDuFichierOrigine" "NoWeb" "blue"
    TouchePour <2>      "/same"     "NouveauBouton $w Same $NomX $NomDuFichierOrigine"
    TouchePour <3>      "/auto"     "NouveauBouton $w Auto $NomX $NomDuFichierOrigine"

    TouchePour $Clavier NouvelleGamme
    TouchePour $Clavier NouvelleCouleur "green"
    TouchePour $Clavier "Show"  "AfficheLesFichiers \[selection get\] AutoManiereAvecShow"
    TouchePour <2>      "/File"  "AfficheLesFichiersApresSplit  \[selection get\] AutoManiereAvecShow"
    TouchePour <3>      "/Split" "OffreLesMots  \[selection get\]"
    
    if { [regexp "AvecGenoret" $Maniere] } {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "ForestGreen"
	TouchePour $Clavier "Show All Uploads" "ShowUploads"
	if {[regexp "AvecAllUploads" $Maniere]} { 
	    TouchePour $Clavier "Show sel. Upload" "ShowUpload \[selection get\]"
	}
	if {[regexp "AvecUpload" $Maniere]} { 
	    TouchePour $Clavier "SetGUs of sel."  "SetGUsWithUpload $NomDuFichierOrigine"
	    TouchePour $Clavier "Store This Upload" "StoreUpload $NomDuFichierOrigine"
	}
	TouchePour $Clavier "ShowGUs" "ShowGUs"
	if {[regexp "AvecGUsList" $Maniere]} { 
	    TouchePour <2>      "/RemGUs"     "RemGUs \[selection get\]"
	}
    }
    if { [regexp "AvecSql" $Maniere] } {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "Purple"
	TouchePour $Clavier "Evaluate again" "after 500 destroy $w ; ShowSomethingFromGenoret \{$PossibleQuery\}"
	if {[regexp "AvecUpdSql" $Maniere]} {
	    TouchePour $Clavier "Update selection" "UpdateOneThingFromGenoret \[selection get\] \{$PossibleQuery\}"	    
	}
    }
    if { [regexp "AvecSaveQueries" $Maniere] } {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "Purple"
	TouchePour $Clavier "Reload"             "ReloadListBox $w.frame.list \[LesLignesDuFichier $NomDuFichierOrigine\]"
	TouchePour $Clavier "Save Queries"       "SaveAs \[set PagePropre($w)\] $NomDuFichierOrigine"
	TouchePour <2>      "/sel"               "SaveAs \[selection get\]      $NomDuFichierOrigine"
	TouchePour <3>      " /Edit" "EditAndShowQueries \[set PagePropre($w)\] $NomDuFichierOrigine"	
    }
    frame $w.frame -borderwidth 10
    pack  $w.frame -side top -expand yes -fill both
    
    
    scrollbar $w.frame.yscroll -command "$w.frame.list yview"
    scrollbar $w.frame.xscroll -command "$w.frame.list xview" \
	    -orient horizontal 
    set Largeur 80
    set Hauteur 35
    if { [regexp "GrandeLargeur" $Maniere] } { set Largeur 128 }
    
    listbox $w.frame.list -width $Largeur -height $Hauteur -setgrid 1 \
	    -yscroll "$w.frame.yscroll set" \
	    -xscroll "$w.frame.xscroll set" \
	    -selectmode extended \
	    -background "LightGrey" \
	    -foreground "Black" \
	    -selectbackground "LightYellow" \
	    -selectforeground "Black" \
	    -font [list Courier [PolicePourListBox]]
    
    grid $w.frame.list    -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky nsew
    grid $w.frame.yscroll -row 0 -column 1 -rowspan 1 -columnspan 1 -sticky nsew
    grid $w.frame.xscroll -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky nsew
    grid rowconfig    $w.frame 0 -weight 1 -minsize 0
    grid columnconfig $w.frame 0 -weight 1 -minsize 0
    
    set nLignes 0
    foreach Ligne [split [set PagePropre($w)] "\n"] {
	incr nLignes
	$w.frame.list insert end $Ligne
    }

    if {$nLignes<30} { $w.frame.list configure -height [expr $nLignes+3] }

    bind $w.frame.list <3>               "DecrisLaLigne %W %x %y"
    bind $w.frame.list <ButtonRelease-3> "DecrisLaLigne %W %x %y Efface"

    if {[regexp "AvecRetour" $Maniere]} {
	$w.frame.list configure -background "green"
    }
    if { [regexp "AvecRetourMaisSansWait" $Maniere] } {
	return $w
    }
    if { [regexp "AvecRetour" $Maniere] } {
	tkwait variable VariableDeRetour($w)
	set v $VariableDeRetour($w)
	unset  VariableDeRetour($w)
	catch {destroy $w}
	return $v
    } else {
	return $w
    }
}

proc Genoret {} {
    Vitrine
}

proc Vitrine {{V ""} {Top ""}} {
    global VitrineCourante
    global LesBoutonsNonOpen
    global LesBoutonsDeVitrine
    global LesBoutonsDeVitrineCaches

    if {$V=="GetVitrine" && [info exists VitrineCourante]} { return $VitrineCourante }

    if {$Top!=""} { toplevel $V }

    set LesBoutonsDeVitrineCaches {}

    set Bouton $V.execquery
    lappend LesBoutons $Bouton
    lappend LesWebDeny $Bouton
    button $Bouton -text "Show something from Genoret"
      bind $Bouton <1> "ShowSomethingFromGenoret"

    set Bouton $V.soptree
    lappend LesBoutons $Bouton
    lappend LesWebDeny $Bouton
    button $Bouton -text "Replace SOPs Tree/ Gallery"
      bind $Bouton <1> "ReplaceGenoretSopTree"
      bind $Bouton <2> "ReplaceGenoretGalleryTree"

    set Bouton $V.uploads
    lappend LesBoutons $Bouton
    lappend LesWebDeny $Bouton
    button $Bouton -text "ShowUploads /Confirm"
      bind $Bouton <1> "ShowUploads genoret"
      bind $Bouton <2> "ShowUploadsConfirmations genoret"

    set Bouton $V.freemind
    lappend LesBoutons $Bouton
    lappend LesWebDeny $Bouton
    button $Bouton -text "Freemind /MindMap"
      bind $Bouton <1> ViewTreeFromXmlFreemindFile
      bind $Bouton <2> MindMap 

    set Bouton $V.bvitrine
    lappend LesBoutons $Bouton
    button $Bouton -text "EVI-Genoret"
      bind $Bouton <1> Boum
    image create photo Vitrine  -file "[GenoretEtc]/VitrineGenoret.gif"
    $Bouton configure -image Vitrine

    set Bouton $V.bSetup
    lappend LesBoutons $Bouton
    lappend LesBoutonsNonOpen $Bouton
    lappend LesWebDeny $Bouton
    button $Bouton -text "SetupGenoret / setenv"
      bind $Bouton <1> SetupGenoret
      bind $Bouton <2> AfficheLEnvironnementDeGenoret

    set Bouton $V.environnement
    lappend LesBoutons $Bouton
    lappend LesBoutonsNonOpen $Bouton
    lappend LesWebDeny $Bouton
    button $Bouton -text "Genoret Sources / .tar / .exe"
    bind $Bouton <1> AfficheLesSourcesDeGenoret
    bind $Bouton <2> TarDeGenoret
    bind $Bouton <3> FreewrapGenoret
    
    set Bouton $V.blittlebrother
    lappend LesBoutons $Bouton
    lappend LesBoutonsNonOpen $Bouton
    lappend LesWebDeny $Bouton
    button $Bouton -text "Genoret chez le Psy"
    bind $Bouton <1> AfficheLesProcs
    bind $Bouton <2> AfficheLesSourcesDeGenoret
    bind $Bouton <3> AfficheLEnvironnementDeGenoret
    
    set Bouton $V.bbigbrother
    lappend LesBoutons $Bouton
    lappend LesBoutonsNonOpen $Bouton
    lappend LesWebDeny $Bouton
    button $Bouton -text "Big Brother /Source/again"
    bind $Bouton <1> DemandeEtExecute
    bind $Bouton <2> ReSource
    bind $Bouton <3> "ReSource Precedent"

    set Bouton $V.bboum
    lappend LesBoutons $Bouton
    button $Bouton -text "Exit Genoret \!"
      bind $Bouton <1> Boum
      bind $Bouton <2> "CodeSecret 0"
      bind $Bouton <3> "CodeSecret 1"

    $Bouton configure -text "Exit"
    bind $Bouton <Enter> "CodeSecret Enter"
    bind $Bouton <Leave> "CodeSecret Leave"
    
    set nB [llength $LesBoutons]
    set iB $nB
    foreach b $LesBoutons {
	if {[PourWscope] && [lsearch -exact $LesWebDeny $b]>-1 } {
	    if {[catch {destroy $b} Message]} { Espionne $Message }
	    continue
	} 
	if { ! [GenoretIsOpen] && [lsearch -exact $LesBoutonsNonOpen $b]>-1 } { 
	    continue
	} 
	lappend LesBoutonsDeVitrine $b
	$b configure -background [Nuance [expr [incr iB -1]/(1.*$nB)] 0.5 0.65]
	$b configure -foreground black
	pack $b -fill both
	if { ! [PourWscope]} {
	    bind $b <Control-3> "if \[OuiOuNon \"Destroy this button ?\"\] { destroy $b }"
	}
    }
    foreach b $LesBoutonsDeVitrineCaches {
	$b configure -background "#654321"
	$b configure -foreground "#123456"
    }
    
    if { $V=="" } {
	set V .
    }
    
    wm title $V "Genoret [VersionDeGenoret]"
    return $V
}

proc CodeSecret {Code {V ""}} {
    global CodeSecret
    if {$Code=="Enter"} { set CodeSecret "" ; return }
    if {$Code=="Leave"} { set CodeSecret "" ; return }
    append CodeSecret $Code
    switch $CodeSecret {
	"00" { Boum }
	"10" { Boum }
	"0100" { eval [Entre] }
	"0101" { AfficheLesProcs }
	"0110" { DemandeEtExecute }
	"111000000" { AfficheLesBoutonsNonOpen $V}
	"111000111" { AfficheLaProc CodeSecret }
	default {}
    }
    return $CodeSecret
}

proc AfficheLesBoutonsNonOpen {{V ""}} {
    global LesBoutonsNonOpen

#    if {$V==""} { set V [Vitrine "GetVitrine"] }
    foreach b $LesBoutonsNonOpen {
	pack $b -fill both
    }
}


