#!/usr/bin/env python3.5
# -*- coding: utf-8 -*-
"""
#  Test de Charge  Version 1.0.2
#  
#  Copyright 2019  <pi@PI3BP-ESSAIS>
"""
ver="102"

import os,psutil
import matplotlib
matplotlib.use('TkAgg')
import matplotlib.gridspec as gridspec
import numpy as np
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg as FCTK
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker
import matplotlib.lines as mlines
from tkinter import *
from datetime import datetime
import subprocess,shlex
from subprocess import call
from time import sleep

def Effa_Termi():
	print ("\033c")
	os.system("clear")

def run_cmd(cmd):
	return subprocess.check_output(cmd, shell=True).decode('utf-8')

def get_CPUtemp():
	#t=psutil.sensors_temperatures()
	#print (t)
	cmd="vcgencmd measure_temp"
	r=str(run_cmd(cmd))
	return  r[5:len(r)-3]

def get_CPUload():
	return str(psutil.cpu_percent(interval=1))

def FERMER():
	global flagRUN,flagAUTO
	Lance_Stress(1)
	flagRUN=False
	flagAUTO=False
	plt.close('all')
	fen1.destroy()

def LANCER():
	global flagRUN,plotCPUx,plotCPUL,plotCPUT,NbP
	flagRUN=not flagRUN
	button1.config(text='ARRET MANUEL' if flagRUN else 'MANUEL')
	button1.config(fg='red' if flagRUN else 'blue')
	NbP=-1		#Compteur de points pour raffraichir le Graphe
	GRAPHE_VIDE()
	fen1.update()
	if flagRUN:
		labact.config(text="ACQUISITION MANUELLE   GRAPHE TOUS LES 10 POINTS")
		ACQ()
	else:
		charge.set(1)
		Lance_Stress(1)
		if len(plotCPUx) >10:GRAPHE()	#on affiche le dernier graphe en mémoire
		labact.config(text="ACQUISITION MANUELLE...TERMINE")
		plotCPUx=[]
		plotCPUL=[]
		plotCPUT=[]
		labT.config(text="----")
		labC.config(text="----")
		NbP=-1
		Voyant('yellow')
		fen1.update()

def LANCER_AUTO():
	global flagAUTO,plotCPUx,plotCPUL,plotCPUT,NbP
	flagAUTO= not flagAUTO
	button2.config(text='ARRET AUTO' if flagAUTO else 'LANCER AUTO')
	button2.config(fg='red' if flagAUTO else 'blue')
	NbP=-1		#Compteur de points dans ACQ
	GRAPHE_VIDE()
	fen1.update()
	cy=0.1 if cycle.get() == 0 else cycle.get()
	cycle.set(cy)
	tmax=(pasAUTO+lissa)*6*(cy+1)
	if flagAUTO:
		while NbP <= pasAUTO*6:
			ACQ()
			t=int((tmax-NbP*(cy+1))/60)
			labact.config(text="ACQUISITION AUTO...ATTENDRE ENVIRON " + str(t) + " Minutes")
			if NbP == pasAUTO*5:
				charge.set(1)
				Lance_Stress(charge.get())
			elif NbP == pasAUTO*4:
				charge.set(5)
				Lance_Stress(charge.get())
			elif NbP == pasAUTO*3:
				charge.set(4)
				Lance_Stress(charge.get())
			elif NbP == pasAUTO*2:
				charge.set(3)
				Lance_Stress(charge.get())
			elif NbP == pasAUTO:
				charge.set(2)
				Lance_Stress(charge.get())
			elif NbP < pasAUTO:
				charge.set(1)
				Lance_Stress(charge.get())
			fen1.update()
			if not flagAUTO:break
	if flagAUTO:GRAPHE()
	labact.config(text="ACQUISITION AUTO...TERMINE")
	flagRUN=False
	flagAUTO=False
	charge.set(1)
	Lance_Stress(1)
	plotCPUx=[]
	plotCPUL=[]
	plotCPUT=[]
	labT.config(text="----")
	labC.config(text="----")
	NbP=-1
	button2.config(text='AUTO')
	button2.config(fg='blue')
	Voyant('yellow')
	fen1.update()

def GRAPHE_VIDE():
	global canvasG
	plt.close('all')
	fig=plt.figure(constrained_layout=True,figsize=(12,4),dpi=100)
	canvasG=FCTK(fig,master=fen1)
	canvasG.get_tk_widget().place(x=160,y=12)
	labact.config(text="")

def GRAPHE():
	plt.close('all')	#pour ne pas empiler les 'Figure'
	fig=plt.figure(constrained_layout=True,figsize=(12,4),dpi=100)
	spec=gridspec.GridSpec(ncols=2,nrows=1,figure=fig)
	G1=fig.add_subplot(spec[0,0])
	G1.xaxis.set_major_locator(ticker.MaxNLocator(5))
	G2=fig.add_subplot(spec[0,1])
	G2.xaxis.set_major_locator(ticker.MaxNLocator(5))
	
	plt.subplot(G1)
	x=np.array(plotCPUx)
	y=np.array(plotCPUL)
	if len(x) > 2:HfinG=x[len(x)-1]
	maxy=np.max(y)
	plt.title("Charge CPU " + x[0] + "  à " + x[len(x)-1] + "  [" + str(len(x)) + " points]",fontsize=12)
	plt.ylabel('%',color='blue')
	plt.ylim(0,maxy+5)
	plt.grid(which='major',axis='x',linewidth=0.75,linestyle='-',color='0.75')
	plt.grid(which='major',axis='y',linewidth=0.75,linestyle='-',color='0.75')
	mx,my=Lissage(x,y,lissa)
	G1.plot(mx,my,color='blue')

	plt.subplot(G2)
	x=np.array(plotCPUx)
	y=np.array(plotCPUT)
	mx,my=Lissage(x,y,lissa)
	miny=np.min(my)
	maxy=np.max(my)
	coul="green"
	if maxy >= limitT1 and maxy < limitT2:
		coul="magenta"
	elif maxy >= limitT2:
		coul="red"
	plt.title("Température CPU " + x[0] + "  à " + x[len(x)-1] + "  [" + str(len(x)) + " points]",fontsize=12)
	plt.ylabel('°C',color=coul)
	plt.ylim(miny-5,maxy+5)
	plt.grid(which='major',axis='x',linewidth=0.75,linestyle='-',color='0.75')
	plt.grid(which='major',axis='y',linewidth=0.75,linestyle='-',color='0.75')
	G2.plot(mx,my,color=coul)
	G2.axhline(y=limitT1,linestyle='--',linewidth=2,color='magenta')
	G2.axhline(y=limitT2,linestyle='--',linewidth=2,color='red')
	G2.axhline(y=limitT3,linestyle='-',linewidth=2,color='red')
	
	canvasG=FCTK(fig,master=fen1)
	canvasG.get_tk_widget().place(x=160,y=12)
	canvasG.draw()

	button3.config(state=ACTIVE)
	fen1.update()

def ENR_GRAPHE():
	d=datetime.now().strftime('%d%m%y-') + HfinG + "_"
	plt.savefig(d + NomFich.get() + ".jpg")

def ACQ():
	global NbP
	Voyant('red')
	cy=0.1 if cycle.get() == 0 else cycle.get()
	cycle.set(cy)
	CPUl=get_CPUload()
	CPUt=get_CPUtemp()
	plotCPUx.append(datetime.now().strftime('%H:%M:%S'))
	plotCPUL.append(float(CPUl))
	plotCPUT.append(float(CPUt))

	if flagRUN and len(plotCPUx) > NbP+10:
		"""Raffraichir le graphe tous les 10 points"""
		GRAPHE()
		NbP += 10
	elif flagAUTO:
		NbP +=1
		sleep(cy)
	"""On reboucle sur la fonction toutes les cycle*1000 mS"""
	if flagRUN or flagAUTO:
		coul="green"
		if float(CPUt) >= limitT1 and float(CPUt) < limitT2:
			coul="magenta"
		elif float(CPUt) >= limitT2:
			coul="red"
		labT.config(text=CPUt + " °C",fg=coul)
		labC.config(text=CPUl + " %",fg='blue')
		Voyant('green')
		fen1.update()
		"""Ne pas Relancer en mode AUTO"""
		if flagRUN:fen1.after(int(cy*1000),ACQ)

def Lissage(Lx,Ly,lissa):
	Lxout=[]
	Lyout=[]
	Lxout=Lx[lissa : -lissa]
	for i in range(lissa,len(Ly)-lissa):
		moy=np.mean(Ly[i-lissa : i+lissa+1])
		Lyout.append(moy)
	return Lxout,Lyout

def Lance_Stress(c):
	opt=[opt1,opt2,opt3,opt4,opt5]
	"""on commence par le fermer"""
	call("pkill -KILL stress",shell=True)
	"""RAZ des Options"""
	for o in opt:
		o.config(fg='black')
	o=opt[c-1]
	o.config(fg='red')
	mode=(c-1)*25
	if mode in (25,50,75,100):
		cmd="stress -c " + str(mode/25)
		prog2=subprocess.Popen(shlex.split(cmd))
		Effa_Termi()

def Voyant(c):
	can0.create_oval(20,185,40,205,width=2,fill=c)

#============================================================================
fen1=Tk(className=' CDBI  Test Charge CPU ' + ver)
fen1.resizable(False,False)
fen1.geometry('1370x445+400+50')
fen1.pack_propagate(1)

""" Variables Globales """
flagRUN=False
flagAUTO=False
plotCPUx=[]
plotCPUL=[]
plotCPUT=[]
charge=IntVar()
charge.set(1)
cycle=IntVar()
cycle.set(1)
NomFich=StringVar()
NomFich.set("Nom-du-Fichier")
HfinG=""	#Heure fin du graphe pour Enregistrement
lissa=3		#Lissage des courbes sur 3 points
limitT1=55
limitT2=60
limitT3=70
NbP=-1
NbAUTO=-1
pasAUTO=100	#"Change stress tous les x points
fig=None	#Figure du graphe

can0=Canvas(fen1,relief='ridge',bg='lightyellow',bd=4,width=142,height=430)
can0.place(x=2,y=2)

labinfo=Label(can0,text="Utilise stress",bg='lightyellow')
labinfo.place(x=20,y=7)

opt1=Radiobutton(can0,text='Charge 0',variable=charge,value=1,bg='lightyellow',fg='red',command=lambda:Lance_Stress(charge.get()))
opt1.place (x=10,y=22)
opt2=Radiobutton(can0,text='Charge 25%',variable=charge,value=2,bg='lightyellow',command=lambda:Lance_Stress(charge.get()))
opt2.place (x=10,y=44)
opt3=Radiobutton(can0,text='Charge 50%',variable=charge,value=3,bg='lightyellow',command=lambda:Lance_Stress(charge.get()))
opt3.place (x=10,y=66)
opt4=Radiobutton(can0,text='Charge 75%',variable=charge,value=4,bg='lightyellow',command=lambda:Lance_Stress(charge.get()))
opt4.place (x=10,y=88)
opt5=Radiobutton(can0,text='Charge 100%',variable=charge,value=5,bg='lightyellow',command=lambda:Lance_Stress(charge.get()))
opt5.place (x=10,y=110)

labCY=Label(can0,text="Cycle en S",bg='lightyellow')
labCY.place(x=15,y=137)
EntreeCY=Entry(can0,textvariable=cycle,font=("Arial",10),width=4)
EntreeCY.place(x=100,y=135)

Voyant('yellow')

labT=Label(can0,text="----",font=('Arial',14,'bold'),bg='lightyellow')
labT.place(x=55,y=170)
labC=Label(can0,text="----",font=('Arial',14,'bold'),bg='lightyellow')
labC.place(x=55,y=190)

button1=Button(can0,text='MANUEL',width=10,command=LANCER)
button1.place(x=20,y=230)

button2=Button(can0,text='AUTO',width=10,command=LANCER_AUTO)
button2.place(x=20,y=270)

EntreeNOM=Entry(can0,textvariable=NomFich,font=('Arial',10),width=19)
EntreeNOM.place(x=7,y=320)

button3=Button(can0,text='ENREGISTRER',width=10,command=ENR_GRAPHE)
button3.place(x=20,y=345)
button3.config(state=DISABLED)

button4=Button(can0,text='FERMER',width=10,command=FERMER)
button4.place(x=20,y=395)

labact=Label(fen1,width=150,bg='grey',fg='white')
labact.place(x=160,y=420)

#On dessine l'emplacement du graphe vide
GRAPHE_VIDE()
labact.config(text="*** BONJOUR ***")

fen1.update()

fen1.mainloop()
